//  wstring.cpp - support for delphi WideString
//  1.1
//  Copyright (c) 1997, 2002 Borland Software Corporation

#include <StrHlpr.hpp>
#include <SysUtils.hpp>
#include <wstring.h>

#if defined(_Windows)
  #include <windows.hpp>
#endif
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <wchar.h>
#ifdef WIDESTRING_IS_BSTR
  #include <utilcls.h>
#endif

namespace System
{
  static int WideCharLen(const WideChar* src)
  {
    int rc = 0;
    if (src)
    {
      while (*src++)
        ++rc;
    }
    return rc;
  }


  __fastcall WideString::WideString(const char*src)
    : Data(0)
  {
    Strhlpr::WideFromPChar(*this, const_cast<char*>(src));
  }


#if 0
  __fastcall WideString::WideString(const WideString& src)
    : Data(0)
  {
    Strhlpr::WideAssign(*this, const_cast<WideString&>(src));
  }
#else
  __fastcall WideString::WideString(const WideString& src)
  {
    if (this != &src) 
    {
      Data = ::SysAllocString(src.Data);   
    }
  }
#endif

  __fastcall WideString::WideString(const AnsiString& src)
    : Data(0)
  {
    Strhlpr::WideFromAnsi(*this, src);
  }

  __fastcall WideString::WideString(const WideChar* src, int len)
    : Data(0)
  {
    if (src && len > 0)
    {
      SetLength(len);
      memcpy(Data, src, len * sizeof(WideChar));
    }
  }

  __fastcall WideString::WideString(const WideChar* src)
    : Data(0)
  {
    if (src)
    {
      int len = WideCharLen(src);
      SetLength(len);
      memcpy(Data, src, len * sizeof(WideChar));
    }
  }

#if !defined(WIDECHAR_IS_WCHAR)
  __fastcall WideString::WideString(const wchar_t* src)
    : Data(0)
  {
    // note! we assume the following:
    // 1) wchar_t uses UCS4 encoding
    // 2) WideChar uses UCS2 encoding
    // 3) it's permissible to "squish" character values that are two
    // large.
    //
    // these are the same assumptions made by System::UCS4StringToWideString
    
    int len = wcslen(src);
    SetLength(len);
    for (int i = 0; i < len; ++i)
      Data[i] = static_cast<WideChar>(src[i]);
  }
  
#endif

  static WideString IntFmt("%d");
  static WideString UintFmt("%u");
  static WideString FltFmt("%g");

  __fastcall WideString::WideString(char src)
    : Data(0)
  {
    static WideString fmt("%c");
    TVarRec r(src);
    WideFmtStr(*this, fmt, &r, 0);
  }


  __fastcall WideString::WideString(short src)
    : Data(0)
  {
    TVarRec r(src);
    Sysutils::WideFmtStr(*this, IntFmt, &r, 0);
  }

  __fastcall WideString::WideString(int src)
    : Data(0)
  {
    TVarRec r(src);
    Sysutils::WideFmtStr(*this, IntFmt, &r, 0);
  }

  __fastcall WideString::WideString(unsigned int src)
    : Data(0)
  {
    TVarRec r(src);
    Sysutils::WideFmtStr(*this, IntFmt, &r, 0);
  }

  __fastcall WideString::WideString(long src)
    : Data(0)
  {
    TVarRec r(src);
    Sysutils::WideFmtStr(*this, IntFmt, &r, 0);
  }

  __fastcall WideString::WideString(unsigned long src)
    : Data(0)
  {
    TVarRec r(src);
    Sysutils::WideFmtStr(*this, IntFmt, &r, 0);

  }

  __fastcall WideString::WideString(__int64 src)
    : Data(0)
  {
    // FIXME: this isn't very efficient, but our TVarRec doesn't
    // currently support int64
    *this = AnsiString(src);
  }

  __fastcall WideString::WideString(unsigned __int64 src)
    : Data(0)
  {
    // FIXME: this isn't very efficient, but our TVarRec doesn't
    // currently support int64
    *this = AnsiString(src);
  }

  __fastcall WideString::WideString(float src)
    : Data(0)
  {
    TVarRec r(src);
    Sysutils::WideFmtStr(*this, FltFmt, &r, 0);
  }

  __fastcall WideString::WideString(double src)
    : Data(0)
  {
    TVarRec r(src);
    Sysutils::WideFmtStr(*this, FltFmt, &r, 0);
  }

  __fastcall WideString::~WideString()
  {
    if (Data)
      Strhlpr::WideFree(*this);
  }


  WideString& __fastcall WideString::operator=(const WideString& src)
  {
    Strhlpr::WideAssign(*this, const_cast<WideString&>(src));
    return *this;
  }

#ifdef WIDESTRING_IS_BSTR
  // ouch! losing this might hurt.  but we need to cater to the new
  WideString& __fastcall WideString::operator=(BSTR src)
  {
    Empty();
    Data = src;
    return *this;
  }

  void __fastcall WideString::Attach(BSTR src)
  {
    // Must Detach what there before Attaching new BSTR
    //
    _ASSERTE(Data == 0);
    Data = src;
  }

  BSTR __fastcall WideString::Detach()
  {
    BSTR bstr = Data;
    Data = 0;
    return bstr;
  }

  void __fastcall WideString::Empty()
  {
    if (Data)
    {
      ::SysFreeString(Data);
      Data = 0;
    }
  }
#endif

  WideString& __fastcall WideString::operator+=(const WideString& src)
  {
    Strhlpr::WideAppend(*this, src);
    return *this;
  }

  bool __fastcall operator==(const WideString& lhs, const WideString& rhs)
  {
    return Strhlpr::WideEqual(lhs, rhs);
  }

  bool __fastcall operator!=(const WideString& lhs, const WideString& rhs)
  {
    return !(lhs == rhs);
  }

  bool __fastcall operator<(const WideString& lhs, const WideString& rhs)
  {
    return Strhlpr::WideLess(lhs, rhs);
  }

  bool __fastcall operator>(const WideString& lhs, const WideString& rhs)
  {
    return Strhlpr::WideGreater(lhs, rhs);
  }


  bool __fastcall operator<=(const WideString& lhs, const WideString& rhs)
  {
    return !(lhs > rhs);
  }

  bool __fastcall operator>=(const WideString& lhs, const WideString& rhs)
  {
    return !(lhs < rhs);
  }

  WideString __fastcall WideString::operator+(const WideString& rhs) const
  {
    return Strhlpr::WideCat(*this, rhs);
  }

  int __fastcall WideString::Length() const
  {
    return Strhlpr::WideLength(*this);
  }

  void __fastcall WideString::Insert(const WideString& src, int index)
  {
    WideInsert(*this, src, index);
  }

  void __fastcall WideString::Delete(int index, int count)
  {
    Strhlpr::WideDelete(*this, index, count);
  }

  void __fastcall WideString::SetLength(int newLength) // newLength: wchar_t count
  {
    Strhlpr::WideSetLength(*this, newLength);
  }

  int __fastcall WideString::Pos(const WideString& subStr) const
  {
    return Strhlpr::WidePos(*this, subStr);
  }

  WideString __fastcall WideString::SubString(int index, int count) const
  {
    return Strhlpr::WideCopy(*this, index, count);
  }

#ifdef WIDESTRING_IS_BSTR
  BSTR __fastcall WideString::Copy(BSTR src)
  {
    return ::SysAllocStringLen(src, ::SysStringLen(src));
  }
#endif
  
#if !defined(WIDECHAR_IS_WCHAR)
  #if sizeof(wchar_t) != 4
    #error unsupported wchar_t
  #endif


  wchar_t* __fastcall WideString::Copy(wchar_t *dst, int sz) const
  {
    if (!dst || sz == -1)
    {
      sz = Length() + 1;
      dst = new wchar_t[sz];
    }
    else
    {
      int len = Length();
      if (sz > len + 1)
        sz = len + 1;
    }
    for (int i = 0; i < sz - 1; ++i)
      dst[i] = Data[i];
    dst[sz] = 0;
    return dst;
  }
#else
  wchar_t* __fastcall WideString::Copy(wchar_t *dst, int sz) const
  {
    if (!dst || sz == -1)
    {
      sz = Length() + 1;
      dst = new wchar_t[sz];
    }
    memcpy(dst, Data, sz);
    return dst;
  }
#endif


} // namespace System
